function [BARS,NODEme,ELEMme,SUPPme,LOADme,HYDHme,uwme,BARMAT] = ...
    GenerateGSMEgeo(NODE,ELEM,SUPP,LOAD,HYDH,uw,MElvl,EMAT,MatProp)
narginchk(5,9)

Nn = size(NODE,1);
Ne = length(ELEM);
Ns = cellfun(@numel,ELEM); % Number of edges (vertices) for each element
Nb = (1/2)*Ns.*(Ns-1)*(MElvl+1)^2; % Number of bars for each element

if (nargin<8)
    EMAT = ones(Ne,1);
    MatProp = [0 0];
elseif (nargin==8)
    error('EMAT and MatProp must always be provided together as input.')
else
    EMAT = round(EMAT);
    if any(EMAT<1), error('Materials must be integers 1,2,3...'), end
    Nmat = max(EMAT);
    if (size(MatProp,1)~=Nmat), error('MatProp must have size (Nmat x 2).'), end
end

[NODEme,ELEMme,SUPPme,LOADme,HYDHme,uwme] = ...
    InsertEdgeNodes(NODE,ELEM,SUPP,LOAD,HYDH,uw,MElvl,Nn,Ne,Ns);

PATT = GetMEpatterns(Ns,MElvl);

BARMAT = nan(sum(Nb),2+size(MatProp,2));
k = 0;
for i=1:Ne
    if Ns(i)<3, error('Elements must have 3+ nodes'), end
    BARMAT(k+(1:Nb(i)),:) = [ELEMme{i}(PATT{Ns(i)}) repmat(MatProp(EMAT(i),:),Nb(i),1)];
    k = k + Nb(i);
end
ind = find(BARMAT(:,1)>BARMAT(:,2));
BARMAT(ind,1:2) = fliplr(BARMAT(ind,1:2));
BARMAT = sortrows(BARMAT);
i = size(BARMAT,1);
while (i>1)
    j = i - 1;
    while ((j>0) && isequal(BARMAT(i,1:2),BARMAT(j,1:2)))
        j = j - 1;
    end
    if (i-j>1)
        BARMAT(j+1,:) = [BARMAT(i,1:2) mean(BARMAT(j+1:i,3:end),1)];
        BARMAT(j+2:i,:) = [];
    end
    i = j;
end

BARS = BARMAT(:,1:2);
BARMAT = BARMAT(:,3:end);
end


function [PATT] = GetMEpatterns(Ns,MElvl)

PATT = cell(max(Ns),1);
for s=3:max(Ns)
    Nn = s*(MElvl+1);
    ELEM = reshape(1:Nn,MElvl+1,s);
    
    L = ones(Nn); % Connectivity matrix
    for i=1:s
        if (i==s)
            j = 1;
        else
            j = i + 1;
        end
        L([ELEM(:,i); ELEM(1,j)],[ELEM(:,i); ELEM(1,j)]) = toeplitz([0 1 zeros(1,MElvl)]);
    end
    [indI,indJ] = find(triu(L));
    PATT{s} = [indI indJ];
end
end


function [NODEme,ELEMme,SUPPme,LOADme,HYDHme,uwme] = ...
    InsertEdgeNodes(NODE,ELEM,SUPP,LOAD,HYDH,uw,MElvl,Nn,Ne,Ns)

EDGE1 = sparse([],[],[],Nn,Nn,sum(Ns)); % 1st element where edge is used
EDGE2 = sparse([],[],[],Nn,Nn,sum(Ns)); % 2nd element where edge is used
INDX1 = sparse([],[],[],Nn,Nn,sum(Ns)); % Edge number in 1st element
INDX2 = sparse([],[],[],Nn,Nn,sum(Ns)); % Edge number in 2nd element
for i=1:Ne
    if isrow(ELEM{i})
        aux = [ELEM{i} ELEM{i}(1)];
        ELEMme{i} = [ELEM{i}; nan(MElvl,Ns(i))];
    elseif iscolumn(ELEM{i})
        aux = [ELEM{i} ELEM{i}(1)];
        ELEMme{i} = [ELEM{i}; nan(MElvl,Ns(i))];
    else
        error('Element %g should be defined as a vector',i)
    end
    for j=1:Ns(i)
        if EDGE1(aux(j),aux(j+1))==0
            EDGE1(aux(j),aux(j+1)) = i; EDGE1(aux(j+1),aux(j)) =-i;
            INDX1(aux(j+1),aux(j)) = j; INDX1(aux(j),aux(j+1)) = j;
        elseif EDGE2(aux(j),aux(j+1))==0
            EDGE2(aux(j),aux(j+1)) = i; EDGE2(aux(j+1),aux(j)) =-i;
            INDX2(aux(j+1),aux(j)) = j; INDX2(aux(j),aux(j+1)) = j;
        else
            aux = [aux(j:j+1) abs(full([EDGE1(aux(j),aux(j+1)) EDGE2(aux(j),aux(j+1))])) i];
            error(sprintf('Edge [%d %d] in 3+ elems: %d %d %d',aux))
        end
    end
end
[edgeI,edgeJ] = find(triu(EDGE1));
NODEme = [NODE; nan(length(edgeI)*MElvl,2)];

% Process the boundary conditions and ready them for edge insertion
IsNodeFixed = false(size(NODEme,1),1);
IsNodeLoaded = false(Nn,1); 
IsNodeh = false(Nn,1); 
IsNodeu = false(Nn,1); 
if isempty(SUPP)
    fixed = [];
else
    fixed = unique(SUPP(:,1));
    IsNodeFixed(fixed) = true;
end
if isempty(LOAD)
    F = sparse([],[],[],size(NODEme,1),2,0);
else
    loaded = any( LOAD(:,2:3)~=0 & ~isnan(LOAD(:,2:3)) ,2);
    IsNodeLoaded(LOAD(loaded,1)) = true;
    Nl = sum(sum(LOAD(:,2:3)~=0 & ~isnan(LOAD(:,2:3))));
    F = sparse([],[],[],size(NODEme,1),2,Nl);
    F(LOAD(:,1),:) = F(LOAD(:,1),:) + LOAD(:,2:3);

end
if isempty(HYDH)
    Fw = sparse([],[],[],size(NODEme,1),1,0);
else
    h = any(HYDH(:,2)~=0 & ~isnan(HYDH(:,2)) ,2);
    IsNodeh(HYDH(h,1)) = true;
    Nl = sum(sum(HYDH(:,2)~=0 & ~isnan(HYDH(:,2))));
    Fw = sparse([],[],[],size(NODEme,1),1,Nl);
    Fw(HYDH(:,1),:) = Fw(HYDH(:,1),:) + HYDH(:,2);
end

if isempty(uw)
    Fu = sparse([],[],[],size(NODEme,1),1,0);
else
    u = any(  ~isnan(uw(:,1)) ,2);
    IsNodeu(u) = true;
    Nl = sum(sum( ~isnan(uw(:,1))));
    Fu = sparse([],[],[],size(NODEme,1),1,Nl);
    Fu(1:Nn, :) = Fu(1:Nn, :) + uw(:, 1);
end
% INSERT EDGE NODES: insertion clever in that it puts on row 1 the original
% nodes and then rows 2--end the new nodes. A reshape will make it perfect.
P = linspace(0,1,MElvl+2)'; P([1 end]) = []; Q = 1 - P;
k = Nn;
for i=1:length(edgeI)
    NODEme(k+(1:MElvl),:) = Q*NODE(edgeI(i),:) + P*NODE(edgeJ(i),:);
    thisELEM = EDGE1(edgeI(i),edgeJ(i));
    if thisELEM>0 % Counter-clockwise insertion
        ELEMme{ thisELEM}(2:end,INDX1(edgeI(i),edgeJ(i))) = k+(1:MElvl);
    else % Clockwise insertion
        ELEMme{-thisELEM}(2:end,INDX1(edgeI(i),edgeJ(i))) = k+(MElvl:-1:1);
    end
    thisELEM = EDGE2(edgeI(i),edgeJ(i));
    if thisELEM>0 % Counter-clockwise insertion
        ELEMme{ thisELEM}(2:end,INDX2(edgeI(i),edgeJ(i))) = k + (1:MElvl);
    elseif (EDGE2(edgeI(i),edgeJ(i))<0) % Clockwise insertion
        ELEMme{-thisELEM}(2:end,INDX2(edgeI(i),edgeJ(i))) = k + (MElvl:-1:1);
    end
    
    % Evaluate if BCs need to be inserted
    if all(IsNodeFixed([edgeI(i) edgeJ(i)]))
        IsNodeFixed(k+(1:MElvl)) = true;
    end
    if all(IsNodeLoaded([edgeI(i) edgeJ(i)]))
        F(k+(1:MElvl),1) = Q*F(edgeI(i),1) + P*F(edgeJ(i),1);
        F(k+(1:MElvl),2) = Q*F(edgeI(i),2) + P*F(edgeJ(i),2);
    end
    if all(IsNodeh([edgeI(i) edgeJ(i)]))
        Fw(k+(1:MElvl),1) = Q*Fw(edgeI(i),1) + P*Fw(edgeJ(i),1);
    end
    if all(IsNodeu([edgeI(i) edgeJ(i)]))
        Fu(k+(1:MElvl),1) = Q*Fu(edgeI(i),1) + P*Fu(edgeJ(i),1);
    end
    
    % Increment the insertion counter
    k = k + MElvl;
end

SUPPme = find(IsNodeFixed);
ind = find(any(F~=0,2)); % Do not use IsNodeLoaded because it recursively
LOADme = [ind full(F(ind,:))];
indw = find(any(Fw~=0,2)); % Do not use IsNodeLoaded because it recursively
HYDHme = [indw full(Fw(indw,:))];
uwme = [ full(Fu(:,:))];
end